
/' As follows is Sprezzo's Qb64 Jan 9th 2023 rebuild of "Make Seamless" '/

Option _Explicit

Screen _NewImage(640, 480, 32)

Dim As Long MainScreen, ImgLoad, CornerUL, CornerUR, CornerBL, CornerBR
Dim As Integer jj, kk
Dim As _Unsigned Long ci, cf
Dim As Integer dx, dy, diag
Dim As Double alf, fac1, fac2

ImgLoad = _LoadImage(Command$)
dx = _Width(ImgLoad)
dy = _Height(ImgLoad)
MainScreen = _NewImage(dx, dy, 32)
Screen MainScreen
_Dest MainScreen

diag = Sqr((_Width / 2) ^ 2 + (_Height / 2) ^ 2)

Dim As _Unsigned Long ScreenBufferMain(0 To _Width, 0 To _Height)

_PutImage (0, 0)-(_Width, _Height), ImgLoad, _Dest, (0, 0)-(_Width(ImgLoad), _Height(ImgLoad))

For jj = 0 To _Width
    For kk = 0 To _Height
        cf = Point(jj, kk)
        ScreenBufferMain(jj, kk) = cf
        PSet (jj, kk), ScreenBufferMain(jj, kk)
    Next
Next

Cls

fac1 = 1.25
fac2 = 1

_Dest CornerUL
For jj = 0 To _Width - 1
    For kk = 0 To _Height - 1
        ci = ScreenBufferMain(jj, kk)
        alf = 255 * (1 - fac1 * Sqr((jj - dx / 2) ^ 2 + (kk - dy / 2) ^ 2) / diag)
        cf = _RGB32(_Red32(ci), _Green32(ci), _Blue32(ci), alf)
        PSet (jj - dx / 2, kk - dy / 2), cf
    Next
Next
_Display

_Dest CornerUR
For jj = 0 To _Width - 1
    For kk = 0 To _Height - 1
        ci = ScreenBufferMain(jj, kk)
        alf = 255 * (1 - fac1 * Sqr((jj - dx / 2) ^ 2 + (kk - dy / 2) ^ 2) / diag)
        cf = _RGB32(_Red32(ci), _Green32(ci), _Blue32(ci), alf)
        PSet (jj + dx / 2, kk - dy / 2), cf
    Next
Next
_Display

_Dest CornerBL
For jj = 0 To _Width - 1
    For kk = 0 To _Height - 1
        ci = ScreenBufferMain(jj, kk)
        alf = 255 * (1 - fac1 * Sqr((jj - dx / 2) ^ 2 + (kk - dy / 2) ^ 2) / diag)
        cf = _RGB32(_Red32(ci), _Green32(ci), _Blue32(ci), alf)
        PSet (jj - dx / 2, kk + dy / 2), cf
    Next
Next
_Display

_Dest CornerBR
For jj = 0 To _Width - 1
    For kk = 0 To _Height - 1
        ci = ScreenBufferMain(jj, kk)
        alf = 255 * (1 - fac1 * Sqr((jj - dx / 2) ^ 2 + (kk - dy / 2) ^ 2) / diag)
        cf = _RGB32(_Red32(ci), _Green32(ci), _Blue32(ci), alf)
        PSet (jj + dx / 2, kk + dy / 2), cf
    Next
Next
_Display

_Dest MainScreen
For jj = 0 To _Width - 1
    For kk = 0 To _Height - 1
        ci = ScreenBufferMain(jj, kk)
        alf = 255 * (1 - fac2 * Sqr((jj - dx / 2) ^ 2 + (kk - dy / 2) ^ 2) / diag)
        cf = _RGB32(_Red32(ci), _Green32(ci), _Blue32(ci), alf)
        PSet (jj, kk), cf
    Next
Next
_Display

Sleep